create or replace package body tbicds.PCK_STAT is
/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
  /*
  Queries and returns static data 
  recordset by collections. 
  */
  procedure GetDataCollectionRS(pi_vSessionID       in varchar2,
                             pi_vSessionClientIP in varchar2,
                             pi_nUserID          in number,
                             pi_vDataCollection  in varchar2,
                             po_nStatusCode      out number,
                             po_vStatusComment   out varchar2,
                             rs                  out RetRefCursor)
  is
  
    v_vSQL varchar2(32767) := '';
  
  begin
  
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
  
    open rs for
      select *
        from stat_data_collection t
       where t.collection_type = pi_vDataCollection
         and t.active = 1
       order by t.collection_item_id;
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
  end;

end PCK_STAT;
/

